/*
 * Decompiled with CFR 0.152.
 */
package acm.gui;

import acm.util.ErrorException;
import acm.util.OptionTable;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.util.Map;

public class TableConstraints
extends GridBagConstraints {
    public int width;
    public int height;
    private static final int MY_PAGE_START = 19;
    private static final int MY_PAGE_END = 20;
    private static final int MY_LINE_START = 21;
    private static final int MY_LINE_END = 22;
    private static final int MY_FIRST_LINE_START = 23;
    private static final int MY_FIRST_LINE_END = 24;
    private static final int MY_LAST_LINE_START = 25;
    private static final int MY_LAST_LINE_END = 26;
    protected static final String[] LEGAL_KEYS = new String[]{"anchor", "bottom", "colspan", "fill", "gridwidth", "gridheight", "gridx", "gridy", "height", "ipadx", "ipady", "left", "right", "rowspan", "top", "weightx", "weighty", "width"};

    public TableConstraints() {
        this("");
    }

    public TableConstraints(String string) {
        this(new OptionTable(string.toLowerCase(), LEGAL_KEYS));
    }

    public TableConstraints(Map map) {
        String string;
        OptionTable optionTable = map instanceof OptionTable ? (OptionTable)map : new OptionTable(map);
        this.gridx = this.parseXYConstraint(optionTable.getOption("gridx"));
        this.gridy = this.parseXYConstraint(optionTable.getOption("gridy"));
        String string2 = optionTable.getOption("gridwidth");
        if (string2 == null) {
            string2 = optionTable.getOption("rowspan");
        }
        if ((string = optionTable.getOption("gridheight")) == null) {
            string = optionTable.getOption("colspan");
        }
        this.gridwidth = this.parseSpanConstraint(string2);
        this.gridheight = this.parseSpanConstraint(string);
        this.fill = this.parseFillConstraint(optionTable.getOption("fill"));
        this.anchor = this.parseAnchorConstraint(optionTable.getOption("anchor"));
        this.ipadx = optionTable.getIntOption("ipadx", 0);
        this.ipady = optionTable.getIntOption("ipady", 0);
        this.weightx = optionTable.getDoubleOption("weightx", 0.0);
        this.weighty = optionTable.getDoubleOption("weighty", 0.0);
        this.insets.left = optionTable.getIntOption("left", 0);
        this.insets.right = optionTable.getIntOption("right", 0);
        this.insets.top = optionTable.getIntOption("top", 0);
        this.insets.bottom = optionTable.getIntOption("bottom", 0);
        this.width = optionTable.getIntOption("width", 0);
        this.height = optionTable.getIntOption("height", 0);
        if (this.gridwidth != 1 && this.width != 0) {
            throw new ErrorException("TableConstraints: Cannot specify both width and gridwidth");
        }
        if (this.gridheight != 1 && this.height != 0) {
            throw new ErrorException("TableConstraints: Cannot specify both height and gridheight");
        }
    }

    public TableConstraints(GridBagConstraints gridBagConstraints) {
        this.gridx = gridBagConstraints.gridx;
        this.gridy = gridBagConstraints.gridy;
        this.gridwidth = gridBagConstraints.gridwidth;
        this.gridheight = gridBagConstraints.gridheight;
        this.fill = gridBagConstraints.fill;
        this.anchor = gridBagConstraints.anchor;
        this.ipadx = gridBagConstraints.ipadx;
        this.ipady = gridBagConstraints.ipady;
        this.weightx = gridBagConstraints.weightx;
        this.weighty = gridBagConstraints.weighty;
        this.insets.left = gridBagConstraints.insets.left;
        this.insets.right = gridBagConstraints.insets.right;
        this.insets.top = gridBagConstraints.insets.top;
        this.insets.bottom = gridBagConstraints.insets.bottom;
        if (gridBagConstraints instanceof TableConstraints) {
            TableConstraints tableConstraints = (TableConstraints)gridBagConstraints;
            this.width = tableConstraints.width;
            this.height = tableConstraints.height;
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public int getFill() {
        return this.fill;
    }

    public int getGridX() {
        return this.gridx;
    }

    public int getGridY() {
        return this.gridy;
    }

    public int getGridWidth() {
        return this.gridwidth;
    }

    public int getGridHeight() {
        return this.gridheight;
    }

    public int getIPadX() {
        return this.ipadx;
    }

    public int getIPadY() {
        return this.ipady;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public double getWeightX() {
        return this.weightx;
    }

    public double getWeightY() {
        return this.weighty;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String toString() {
        String string = this.getClass().getName();
        string = String.valueOf(string) + "[gridx=" + this.gridx + ",gridy=" + this.gridy;
        switch (this.fill) {
            case 3: {
                string = String.valueOf(string) + ",fill=VERTICAL";
                break;
            }
            case 2: {
                string = String.valueOf(string) + ",fill=HORIZONTAL";
                break;
            }
            case 1: {
                string = String.valueOf(string) + ",fill=BOTH";
                break;
            }
        }
        switch (this.anchor) {
            case 11: {
                string = String.valueOf(string) + ",anchor=NORTH";
                break;
            }
            case 15: {
                string = String.valueOf(string) + ",anchor=SOUTH";
                break;
            }
            case 13: {
                string = String.valueOf(string) + ",anchor=EAST";
                break;
            }
            case 17: {
                string = String.valueOf(string) + ",anchor=WEST";
                break;
            }
            case 12: {
                string = String.valueOf(string) + ",anchor=NORTHEAST";
                break;
            }
            case 18: {
                string = String.valueOf(string) + ",anchor=NORTHWEST";
                break;
            }
            case 14: {
                string = String.valueOf(string) + ",anchor=SOUTHEAST";
                break;
            }
            case 16: {
                string = String.valueOf(string) + ",anchor=SOUTHWEST";
                break;
            }
            case 19: {
                string = String.valueOf(string) + ",anchor=PAGE_START";
                break;
            }
            case 20: {
                string = String.valueOf(string) + ",anchor=PAGE_END";
                break;
            }
            case 21: {
                string = String.valueOf(string) + ",anchor=LINE_START";
                break;
            }
            case 22: {
                string = String.valueOf(string) + ",anchor=LINE_END";
                break;
            }
            case 23: {
                string = String.valueOf(string) + ",anchor=FIRST_LINE_START";
                break;
            }
            case 24: {
                string = String.valueOf(string) + ",anchor=FIRST_LINE_END";
                break;
            }
            case 25: {
                string = String.valueOf(string) + ",anchor=LAST_LINE_START";
                break;
            }
            case 26: {
                string = String.valueOf(string) + ",anchor=LAST_LINE_END";
                break;
            }
        }
        if (this.gridwidth != 1) {
            string = String.valueOf(string) + ",gridwidth=" + this.gridwidth;
        }
        if (this.gridheight != 1) {
            string = String.valueOf(string) + ",gridheight=" + this.gridheight;
        }
        if (this.ipadx != 0) {
            string = String.valueOf(string) + ",ipadx=" + this.ipadx;
        }
        if (this.ipady != 0) {
            string = String.valueOf(string) + ",ipady=" + this.ipady;
        }
        if (this.insets.left != 0) {
            string = String.valueOf(string) + ",left=" + this.insets.left;
        }
        if (this.insets.right != 0) {
            string = String.valueOf(string) + ",right=" + this.insets.right;
        }
        if (this.insets.top != 0) {
            string = String.valueOf(string) + ",top=" + this.insets.top;
        }
        if (this.insets.bottom != 0) {
            string = String.valueOf(string) + ",bottom=" + this.insets.bottom;
        }
        if (this.width != 0) {
            string = String.valueOf(string) + ",width=" + this.width;
        }
        if (this.height != 0) {
            string = String.valueOf(string) + ",height=" + this.height;
        }
        string = String.valueOf(string) + "]";
        return string;
    }

    private int parseXYConstraint(String string) {
        if (string == null) {
            return -1;
        }
        if (string.equals("relative")) {
            return -1;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorException("TableConstraints: Illegal grid coordinate");
        }
    }

    private int parseSpanConstraint(String string) {
        if (string == null) {
            return 1;
        }
        if (string.equals("relative")) {
            return -1;
        }
        if (string.equals("remainder")) {
            return 0;
        }
        try {
            return Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ErrorException("TableConstraints: Illegal span constraint");
        }
    }

    private int parseAnchorConstraint(String string) {
        if (string == null) {
            return 10;
        }
        if (string.equals("center")) {
            return 10;
        }
        if (string.equals("north")) {
            return 11;
        }
        if (string.equals("south")) {
            return 15;
        }
        if (string.equals("east")) {
            return 13;
        }
        if (string.equals("west")) {
            return 17;
        }
        if (string.equals("northeast") || string.equals("ne")) {
            return 12;
        }
        if (string.equals("northwest") || string.equals("nw")) {
            return 18;
        }
        if (string.equals("southeast") || string.equals("se")) {
            return 14;
        }
        if (string.equals("southwest") || string.equals("sw")) {
            return 16;
        }
        if (string.equals("page_start")) {
            return 19;
        }
        if (string.equals("page_end")) {
            return 20;
        }
        if (string.equals("line_start")) {
            return 21;
        }
        if (string.equals("line_end")) {
            return 22;
        }
        if (string.equals("first_line_start")) {
            return 23;
        }
        if (string.equals("first_line_end")) {
            return 24;
        }
        if (string.equals("last_line_start")) {
            return 25;
        }
        if (string.equals("last_line_end")) {
            return 26;
        }
        throw new ErrorException("TableConstraints: Illegal anchor specification");
    }

    private int parseFillConstraint(String string) {
        if (string == null || string.equals("none")) {
            return 0;
        }
        if (string.equals("horizontal")) {
            return 2;
        }
        if (string.equals("vertical")) {
            return 3;
        }
        if (string.equals("both")) {
            return 1;
        }
        throw new ErrorException("TableConstraints: Illegal fill specification");
    }
}

